/*
 *Caracteristique photoresistance
 *18 mars 2022
 *Prof-TC
 */
//--------------------------------------------------------------------------------------------------
// Mesure de la résistance d'une Photoresistance
//--------------------------------------------------------------------------------------------------

#define R  220    // Résistance du pont

float U1;           // Potentiel a la borne de la resistance R
float U2;           // Potentiel a la borne de la photoresistance
float I;            // Courant dans le circuit

//--------------------------------------------------------------------------------------------------

void setup() {
   Serial.begin(9600);      // Paramétrage du port série
   Serial.println("Caracteristique d'une photoresistance");   //Titre du programme
   Serial.println("");      // saute une ligne
   Serial.print("I (mA)     ");  // donne la valeur du courant en milliampere
   Serial.println("U (V)"); // donne la valeur de la tension en Volt
   Serial.println("");      // saute une ligne
}

//--------------------------------------------------------------------------------------------------

void loop() {
  U1 = analogRead(A1)*5.0/1023;      // Lecture potentiel A1
  U2 = analogRead(A2)*5.0/1023;      // Lecture potentiel A2
  I=1000*(U1-U2)/R;                  // Calcul courant en milliampere
  Serial.print(I);                   // Affichage du courant I en milliampere traversant la photoresistance
  Serial.print("       ");           // Espacement
  Serial.println(U2);                // Affichage de la tension U en Volt aux bornes de la photoresistance
  delay(1000);                       // Temporisation de 5s
}

//--------------------------------------------------------------------------------------------------
